#ifndef __SERCOSIII_SL_COM_ERROR_H
#define __SERCOSIII_SL_COM_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// SercosIII Slave COM error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_NUM_OF_SLAVES
//
// MessageText:
//
//  Invalid number of slaves or invalid slave number.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_NUM_OF_SLAVES ((TLR_RESULT)0xC04E0031L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SYNC_VERSION
//
// MessageText:
//
//  Invalid or not supported SCP_Sync version.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SYNC_VERSION ((TLR_RESULT)0xC04E0032L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SMP_VERSION
//
// MessageText:
//
//  Invalid or not supported SCP_SMP version.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SMP_VERSION ((TLR_RESULT)0xC04E0033L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_NRT_VERSION
//
// MessageText:
//
//  Invalid or not supported SCP_NRT version.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_NRT_VERSION ((TLR_RESULT)0xC04E0034L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SYNC_CONFIG_FLAGS
//
// MessageText:
//
//  Invalid or not supported Sync configuration flags.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SYNC_CONFIG_FLAGS ((TLR_RESULT)0xC04E0035L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_CONCLK_SIGNAL_TOO_SHORT
//
// MessageText:
//
//  ConClk is enabled, but signal length below minimum 1000 ns.
//
#define TLR_E_SERCOSIII_SL_COM_CONCLK_SIGNAL_TOO_SHORT ((TLR_RESULT)0xC04E0036L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_DIVCLK_SIGNAL
//
// MessageText:
//
//  DivClk is enabled, but signal length below minimum 1us or greater than 20us.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_DIVCLK_SIGNAL ((TLR_RESULT)0xC04E0037L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_DIVCLK_CONFIG
//
// MessageText:
//
//  DivClk is enabled, but config is invalid.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_DIVCLK_CONFIG ((TLR_RESULT)0xC04E0038L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SERCOS_ADR
//
// MessageText:
//
//  Invalid SERCOS address.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SERCOS_ADR ((TLR_RESULT)0xC04E0039L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SCP_VERSION
//
// MessageText:
//
//  Invalid or not supported SCP version.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SCP_VERSION ((TLR_RESULT)0xC04E003AL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SLAVE_FLAGS
//
// MessageText:
//
//  Invalid or not supported slave flags.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SLAVE_FLAGS ((TLR_RESULT)0xC04E003BL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_DEFAULT_OD_NOT_AVAILABLE
//
// MessageText:
//
//  Default object dictionary not available.
//
#define TLR_E_SERCOSIII_SL_COM_DEFAULT_OD_NOT_AVAILABLE ((TLR_RESULT)0xC04E003CL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_USER_SCP_VERSION
//
// MessageText:
//
//  Invalid or not supported USER_SCP version.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_USER_SCP_VERSION ((TLR_RESULT)0xC04E003DL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_FSP_TYPE
//
// MessageText:
//
//  Invalid or not supported FSP Type.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_FSP_TYPE ((TLR_RESULT)0xC04E003EL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_PROCESS_DATA_IMG
//
// MessageText:
//
//  Invalid or not supported process data image, it is greater than 256 bytes.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_PROCESS_DATA_IMG ((TLR_RESULT)0xC04E003FL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_CLEAN_UP_OD_FAILED
//
// MessageText:
//
//  Cleaning up the object dictionary failed.
//
#define TLR_E_SERCOSIII_SL_COM_CLEAN_UP_OD_FAILED ((TLR_RESULT)0xC04E0040L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_CONCLK_SIGNAL_TOO_LONG
//
// MessageText:
//
//  ConClk is enabled, but signal length above maximum 655350 ns.
//
#define TLR_E_SERCOSIII_SL_COM_CONCLK_SIGNAL_TOO_LONG ((TLR_RESULT)0xC04E0041L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_RTDATA_LENGTH_NOT_EVEN
//
// MessageText:
//
//  The RT-Data length may not be odd. Configure a even length.
//
#define TLR_E_SERCOSIII_SL_COM_RTDATA_LENGTH_NOT_EVEN ((TLR_RESULT)0xC04E0042L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SYSTEM_START_VALUE
//
// MessageText:
//
//  The value for ulSystemStart is out of range.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SYSTEM_START_VALUE ((TLR_RESULT)0xC04E0043L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_VENDOR_CODE_VALUE
//
// MessageText:
//
//  The value for usVendorCode is out of range.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_VENDOR_CODE_VALUE ((TLR_RESULT)0xC04E0044L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_DUBLICATE_CONFIGURED_SERCOS_ADDRESSES
//
// MessageText:
//
//  At the multiple slave device one sercos address was double configured.
//
#define TLR_E_SERCOSIII_SL_COM_DUBLICATE_CONFIGURED_SERCOS_ADDRESSES ((TLR_RESULT)0xC04E0045L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_INVALID_SIP_VERSION
//
// MessageText:
//
//  Invalid version of SIP.
//
#define TLR_E_SERCOSIII_SL_COM_INVALID_SIP_VERSION ((TLR_RESULT)0xC04E0046L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_RESET_ONLY_THROUGH_S_0_0099
//
// MessageText:
//
//  A Reset of a C1D error code is just allowed with S-0-0099.
//
#define TLR_E_SERCOSIII_SL_COM_RESET_ONLY_THROUGH_S_0_0099 ((TLR_RESULT)0xC04E0047L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_MINIMUM_VALUE_NOT_READABLE
//
// MessageText:
//
//  The minimum value is not readable.
//
#define TLR_E_SERCOSIII_SL_COM_MINIMUM_VALUE_NOT_READABLE ((TLR_RESULT)0xC04E0048L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_MAXIMUM_VALUE_NOT_READABLE
//
// MessageText:
//
//  The maximum value is not readable.
//
#define TLR_E_SERCOSIII_SL_COM_MAXIMUM_VALUE_NOT_READABLE ((TLR_RESULT)0xC04E0049L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NAME_NOT_READABLE
//
// MessageText:
//
//  The name is not readable.
//
#define TLR_E_SERCOSIII_SL_COM_NAME_NOT_READABLE ((TLR_RESULT)0xC04E004AL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_ATTRIBUTE_NOT_READABLE
//
// MessageText:
//
//  The attribute is not readable.
//
#define TLR_E_SERCOSIII_SL_COM_ATTRIBUTE_NOT_READABLE ((TLR_RESULT)0xC04E004BL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_UNIT_NOT_READABLE
//
// MessageText:
//
//  The unit is not readable.
//
#define TLR_E_SERCOSIII_SL_COM_UNIT_NOT_READABLE ((TLR_RESULT)0xC04E004CL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NO_ENTRY_DELETED
//
// MessageText:
//
//  No entry found to deleted.
//
#define TLR_E_SERCOSIII_SL_COM_NO_ENTRY_DELETED ((TLR_RESULT)0xC04E004DL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_MAXIMUM_REGISTRATION_LISTENERS_REACHED
//
// MessageText:
//
//  All listening slots are in use.
//
#define TLR_E_SERCOSIII_SL_COM_MAXIMUM_REGISTRATION_LISTENERS_REACHED ((TLR_RESULT)0xC04E004EL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NO_DIAGNOSIS_NUMBER_SET
//
// MessageText:
//
//  No diagnosis number set. A diagnosis number must be different to zero
//
#define TLR_E_SERCOSIII_SL_COM_NO_DIAGNOSIS_NUMBER_SET ((TLR_RESULT)0xC04E004FL)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_JUST_ALLOWED_IN_CP3_OR_CP4
//
// MessageText:
//
//  Reconfiguration with this packet is just allowed in CP3 or CP4.
//
#define TLR_E_SERCOSIII_SL_COM_JUST_ALLOWED_IN_CP3_OR_CP4 ((TLR_RESULT)0xC04E0050L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_JUST_ALLOWED_IN_CP2
//
// MessageText:
//
//  Reconfiguration with this packet is just allowed in CP2.
//
#define TLR_E_SERCOSIII_SL_COM_JUST_ALLOWED_IN_CP2 ((TLR_RESULT)0xC04E0051L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NO_VAR_CONFIG
//
// MessageText:
//
//  This packet is just allowed if VarCfg is configured.
//
#define TLR_E_SERCOSIII_SL_COM_NO_VAR_CONFIG ((TLR_RESULT)0xC04E0052L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NO_STORAGE_LEFT
//
// MessageText:
//
//  This storage left.
//
#define TLR_E_SERCOSIII_SL_COM_NO_STORAGE_LEFT ((TLR_RESULT)0xC04E0053L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_NUMBER_CONNECTIONS_EXCEEDED
//
// MessageText:
//
//  The number of connections exceeded.
//
#define TLR_E_SERCOSIII_SL_COM_NUMBER_CONNECTIONS_EXCEEDED ((TLR_RESULT)0xC04E0054L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_RX_BUFFER_INTERRUPT_WITHOUT_SYNC
//
// MessageText:
//
//  The configuration of the RX Buffer Interrupt is just possible if Sync is also enabled.
//
#define TLR_E_SERCOSIII_SL_COM_RX_BUFFER_INTERRUPT_WITHOUT_SYNC ((TLR_RESULT)0xC04E0055L)

//
// MessageId: TLR_E_SERCOSIII_SL_COM_RX_WRONG_SERCOS_VERSION_CONFIGURED
//
// MessageText:
//
//  The configured Sercos Version is invalid.
//
#define TLR_E_SERCOSIII_SL_COM_RX_WRONG_SERCOS_VERSION_CONFIGURED ((TLR_RESULT)0xC04E0056L)




#endif  //__SERCOSIII_COM_ERROR_H

